<?php

namespace App\Console\Commands;

use App\Enums\RoleEnum;
use App\Models\AssociationUser;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class AddDataInAssociationUserCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'add-data-in-association-user-command';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            $this->addDataIntoAssociationUserTable();
        } catch (\Exception $exception) {
            Log::error("add-data-in-association-user-command - " . $exception->getMessage());
        }

        return 0;
    }

    public function addDataIntoAssociationUserTable()
    {
        $users = User::where('role',RoleEnum::MEMBER)->whereNotNull('association_id')->get();
        foreach($users as $user){
            AssociationUser::UpdateOrCreate([
                'user_id' => $user->id,
                'association_id' => $user->association_id,
            ]);
        }
    }
}
