<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Imports\DataImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Log;

class ImportDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:esi-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add Association Members Data.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->line('Import Starts.');
        $path = storage_path('excel/ESI_Data.xlsx');
        $dataImport = new DataImport();
        Excel::import($dataImport, $path);
        $this->line('Import Ends.');
    }
}
