<?php

namespace App\Console\Commands;

use App\Helpers\MetaClient;
use App\Models\MessageTemplate;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class PendingMessageTemplateUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pending:message:template';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            $this->updateMessageTemplateStatus();
        } catch (\Exception $exception) {
            Log::error("pending:message:template - " . $exception->getMessage());

            // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
            //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
            // Log::channel("meta")
            //     ->error("pending:message:template - " . $exception->getMessage());
        }

        return 0;
    }

    public function updateMessageTemplateStatus($url = null)
    {
        $api = new MetaClient();

        if ($url) {
            $response = $api->get($url);
        } else {
            $response = $api->getMessageTemplates();
        }

        if ($response->ok()) {
            $json = $response->json();
            $data = $json["data"] ?? [];
            foreach ($data as $template) {
                $messageTemplate = MessageTemplate::where('template_id', $template["id"])->first();
                if (
                    $messageTemplate &&
                    $messageTemplate->status != $template["status"]
                ) {

                    $prevStatus = $messageTemplate->status;
                    $messageTemplate->status = $template["status"];
                    $messageTemplate->save();

                    Log::info('message template status changes from ' . $prevStatus . ' to ' . $messageTemplate->status . '--- Message template ->' . $messageTemplate->id);

                    // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
                    //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
                    // Log::channel('meta')
                    //     ->info('message template status changes from ' . $prevStatus . ' to ' . $messageTemplate->status . '--- Message template ->' . $messageTemplate->id);
                }
            }

            $next = $json["paging"]["next"] ?? null;
            if ($next) {
                $this->updateMessageTemplateStatus($next);
            }
        }
    }
}
