<?php

namespace App\Console\Commands;

use App\Enums\MailTemplateCampaignEnum;
use App\Helpers\SendEmailCampaign;
use App\Models\MailTemplateCampaign;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class SendBulkEmails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sendEmail:cron {--missing}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Email will be sent on defined date and time';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $this->runForHost($host = null);
        return true;
    }

    public function runForHost($host)
    {
        Log::info("Send Bulk Emails Job Running");
        // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
        //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
        // Log::channel('meta')->info("Send Bulk Emails Job Running");
        if ($this->option("missing")) {
            $mailTemplateCampaigns = MailTemplateCampaign::where('status', MailTemplateCampaignEnum::IN_PROGRESS)
                ->get();

            foreach ($mailTemplateCampaigns as $campaign) {
                $this->line("Missing: " . $campaign->template_name);
                Log::info("Email template scheduling Cron host: {$host} / Template name - {$campaign->template_name} ");
                // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
                //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
                // Log::channel('meta')
                //     ->info("Email template scheduling Cron host: {$host} / Template name - {$campaign->template_name} ");

                (new SendEmailCampaign())->sendEmailCampaign($host, $campaign);
            }
            return;
        }

        $mailTemplateCampaigns = MailTemplateCampaign::where('status', MailTemplateCampaignEnum::PENDING)
            ->where('scheduled_at', '<', date('Y-m-d H:i'))
            ->get();

        foreach ($mailTemplateCampaigns as $campaign) {
            Log::info("Email template scheduling Cron host: {$host} / Template name - {$campaign->template_name} ");
            // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
            //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
            // Log::channel('meta')
            //     ->info("Email template scheduling Cron host: {$host} / Template name - {$campaign->template_name} ");

            (new SendEmailCampaign())->sendEmailCampaign($host, $campaign);
        }
        Log::info("Send Bulk Emails Job Finished");
        // "error": "The stream or file "/var/www/html/vdoconfrence/storage/logs/meta-2024-10-30.log 
        //could not be opened in append mode: Failed to open stream: Permission denied\nThe exception occurred while attempting to log
        // Log::channel('meta')->info("Send Bulk Emails Job Finished");

    }
}
