<?php

namespace App\Helpers;

use App\Models\User;

interface PaymentInterface
{
    public function createOrder($eventName, $price, User $user, $data);

    /**
     * @param $paymentInfo
     * @return array
     * @throws \Exception
     */
    public function getPaymentDetails($paymentInfo);

    /**
     * @param $orderId
     * @return array
     */
    public function getOrderDetails($orderId);

    /**
     * @param array $order
     * @return array
     */
    public function parseOrderInfo($order);
}
