<?php

namespace App\Helpers;

use App\Enums\MailTemplateCampaignEnum;
use App\Enums\MetaFileExtensionEnum;
use App\Jobs\SendEventMailJob;
use App\Jobs\SendMailJob;
use App\Models\MailTemplateCampaign;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\File\File;

class SendEmailCampaign
{

    public function __construct()
    {
        //
    }

    function sendEmailCampaign($host, MailTemplateCampaign $mailTemplateCampaign)
    {

        $mailTemplateCampaign->status = MailTemplateCampaignEnum::IN_PROGRESS;
        $mailTemplateCampaign->save();

        $pendingUsers = array_values(
            array_diff(
                $mailTemplateCampaign->users,
                array_merge($mailTemplateCampaign->success_users, $mailTemplateCampaign->fail_users)
            )
        );

        $mailTemplateCampaignId = $mailTemplateCampaign->id;
        $users = User::whereIn('id', $pendingUsers)->whereNotNull('email')->get();
        $fromMail = $mailTemplateCampaign->emailTemplate->from;
        $subject = $mailTemplateCampaign->emailTemplate->subject;
        $templateId = $mailTemplateCampaign->emailTemplate->template_id;
        $dynamicVariables = ($mailTemplateCampaign->emailTemplate->dynamic_variables);
        $attachments = [];

        if ($mailTemplateCampaign->emailTemplate->getAttachments()) {
            foreach ($mailTemplateCampaign->emailTemplate->getAttachments() as $attachment) {
                $extension = pathinfo($attachment->path, PATHINFO_EXTENSION);
                $contentType = '';

                switch ($extension) {
                    case 'png':
                    case 'jpg':
                    case 'jpeg':
                        $contentType = "image/png";
                        break;
                    case 'pdf':
                        $contentType = "application/pdf";
                        break;
                    case 'xlsx':
                        $contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                        break;
                    case 'doc':
                        $contentType = "application/msword";
                        break;
                    default:
                        $contentType = "application/octet-stream";
                        break;
                }
                $attachments[] = [
                    'ContentType' => $contentType,
                    'Filename' => $attachment->name,
                    'Base64Content' => (base64_encode(file_get_contents(storage_path('/app/public/' . $attachment->path)))),
                ];
            }
        }

        foreach ($users as $user) {
            if ($user->email != null) {
                $dynamicData = [];
                foreach ($dynamicVariables as $variable) {
                    $dynamicData[$variable] = $user->$variable ?? '';
                }
                dispatch_sync(new SendMailJob(
                    [
                        'Email' => $fromMail
                    ],
                    [
                        [
                            'Email' => $user->email,
                        ]
                    ],
                    $subject,
                    $templateId,
                    $dynamicData,
                    $attachments,
                    ["user_id" => $user->id, 'mail_template_campaign_id' => $mailTemplateCampaignId],
                ));
            }
        }
        return true;
    }

    function sendEventEmailCampaign($host, MailTemplateCampaign $mailTemplateCampaign)
    {

        $mailTemplateCampaign->status = MailTemplateCampaignEnum::IN_PROGRESS;
        $mailTemplateCampaign->save();

        $pendingUsers = array_values(
            array_diff(
                $mailTemplateCampaign->users,
                array_merge($mailTemplateCampaign->success_users, $mailTemplateCampaign->fail_users)
            )
        );

        $mailTemplateCampaignId = $mailTemplateCampaign->id;
        $users = User::whereIn('id', $pendingUsers)->whereNotNull('email')->get();
        $fromMail = $mailTemplateCampaign->eventEmailTemplate->from;
        $subject = $mailTemplateCampaign->eventEmailTemplate->subject;
        $templateId = $mailTemplateCampaign->eventEmailTemplate->template_id;
        $dynamicVariables = ($mailTemplateCampaign->eventEmailTemplate->dynamic_variables);
        $cc = $mailTemplateCampaign->eventEmailTemplate->cc ?? [];
        $bcc = $mailTemplateCampaign->eventEmailTemplate->bcc ?? [];
        $attachments = [];

        if ($mailTemplateCampaign->eventEmailTemplate->getAttachments()) {
            foreach ($mailTemplateCampaign->eventEmailTemplate->getAttachments() as $attachment) {
                $extension = pathinfo($attachment->path, PATHINFO_EXTENSION);
                $contentType = '';

                switch ($extension) {
                    case 'png':
                    case 'jpg':
                    case 'jpeg':
                        $contentType = "image/png";
                        break;
                    case 'pdf':
                        $contentType = "application/pdf";
                        break;
                    case 'xlsx':
                        $contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                        break;
                    case 'doc':
                        $contentType = "application/msword";
                        break;
                    default:
                        $contentType = "application/octet-stream";
                        break;
                }
                $attachments[] = [
                    'ContentType' => $contentType,
                    'Filename' => $attachment->name,
                    'Base64Content' => (base64_encode(file_get_contents(storage_path('/app/public/' . $attachment->path)))),
                ];
            }
        }
        foreach ($users as $user) {
            if ($user->email != null) {
                $dynamicData = [];
                foreach ($dynamicVariables as $variable) {
                    $dynamicData[$variable] = $user->$variable ?? '';
                }
                dispatch_sync(new SendEventMailJob(
                    [
                        'Email' => $fromMail
                    ],
                    [
                        [
                            'Email' => $user->email,
                        ]
                    ],
                    $subject,
                    $templateId,
                    $dynamicData,
                    $attachments,
                    ["user_id" => $user->id, 'mail_template_campaign_id' => $mailTemplateCampaignId],
                    $cc,
                    $bcc,
                ));
            }
        }
        return true;
    }
}
