<?php

namespace App\Helpers;

use App\Models\Event;
use App\Models\User;
use App\Models\RequestLog;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class WatiMessage
{
    public static function sendMessageIfRequired(User $user, Event $event, $watiTemplate)
    {
        Log::info("Wati Message Start:" . $user->id);

        $watiToken = config('wati.token');
        $watiEndPointUrl = config('wati.endpoint');

        $wati = new Wati($watiToken, $watiEndPointUrl);

        self::syncUser($wati, $user);

        $params = [
            ["name" => "name", "value" => $user->name],
            ["name" => "event_date", "value" => date('d-m-Y', strtotime($event->date))],
            ["name" => "time", "value" => "8:00 PM to 9:00 PM"],
        ];

        $broadCastName = time();

        $wati->sendWatiMessage($user->wati_wa_id, $event, $broadCastName, $params, $watiTemplate);
    }

    protected static function syncUser(Wati $wati, User $user)
    {
        if (!$user->wati_id) {
            self::createWatiContact($wati, $user);
        }

        if (Carbon::now()->subMinutes(30)->greaterThan($user->created_at)) {
            self::updateWatiContact($wati, $user);
        }
    }

    protected static function createWatiContact(Wati $wati, User $user)
    {
        $countryCode = str_replace("+", "", $user->country_code);
        $response = $wati->createContact("{$countryCode}{$user->contact}", $user->name, []);
        Log::info("create contact" . json_encode($response));
        if ($response && isset($response['contact'])) {
            $user->wati_wa_id = $response['contact']['wAid'];
            $user->wati_id = $response['contact']['id'];
            $user->save();
        } else {
            Log::error("Wati Create Error: User: {$user->id} - " . json_encode($response));
        }
    }

    protected static function updateWatiContact(Wati $wati, User $user)
    {
        $countryCode = str_replace("+", "", $user->country_code);
        $response = $wati->updateContact("{$countryCode}{$user->contact}", []);
        Log::info("update contact" . json_encode($response));
    }
}
