<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\AssociationDetailResource;
use App\Models\AssociationDetail;
use App\Models\User;
use Illuminate\Http\Request;

class AssociationDetailController extends Controller
{
    public function index(Request $request)
    {
        try {
            $associationDetails = AssociationDetail::where('association_id', $request->attributes->get('association_id'))->first();
            $data = $associationDetails ? new AssociationDetailResource($associationDetails) : [];
            return $this->sendJson($data);
        } catch (\Exception $e) {
            $this->logError($e, "Get Association Details Error");
            return $this->sendError($e->getMessage());
        }
    }
}
