<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\CalenderResource;
use App\Models\Calendar;
use Illuminate\Http\Request;

class CalenderController extends Controller
{
    public function index(Request $request)
    {
        try {
            $calenders = Calendar::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->orderByDesc('date');
            $calenders = $calenders->filterCalendars();
            $calenders = $calenders->simplePaginate(20);
            return CalenderResource::collection($calenders);
        } catch (\Exception $e) {
            $this->logError($e, "Get Events Error");
            return $this->sendError($e->getMessage());
        }
    }
}
