<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\EventPageEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\EventAboutUsResource;
use App\Models\EventPage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventAboutUsController extends Controller
{
    public function index(Request $request)
    {
        try {
            $aboutUs = EventPage::where('event_id', $request->attributes->get('event_id'))->where('type', EventPageEnum::ABOUT_US)->first();
            if ($aboutUs) {
                return new EventAboutUsResource($aboutUs);
            }
            return $this->sendError("About us details not found");
        } catch (\Exception $e) {
            $this->logError($e, "Event About Us Error");
            return $this->sendError($e->getMessage());
        }
    }
}
