<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventAppHomeButtonResource;
use App\Models\EventAppHomeButton;
use Illuminate\Http\Request;

class EventAppHomeButtonController extends Controller
{
    public function index(Request $request)
    {
        try {
            $homeButtons = EventAppHomeButton::where('event_id', $request->attributes->get('event_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->get();
            return $this->sendJson(EventAppHomeButtonResource::collection($homeButtons));
        } catch (\Exception $e) {
            $this->logError($e, "Get Event App Home Button Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function youtubeLink(Request $request)
    {
        try {
            $event = getEventFromId($request->attributes->get('event_id'));
            return $this->sendJson([
                'youtube_link' => getEnvironmentVariable('youtube_link', $event->id),
            ]);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event youtube link Error");
            return $this->sendError($e->getMessage());
        }
    }
}
