<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventDocumentListResource;
use App\Models\EventDocumentList;
use Illuminate\Http\Request;

class EventDocumentListController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventDocumentList = EventDocumentList::where('event_id', $request->attributes->get('event_id'));
            $eventDocumentList = $eventDocumentList->simplePaginate(25);
            return EventDocumentListResource::collection($eventDocumentList);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Document List Error");
            return $this->sendError($e->getMessage());
        }
    }
}
