<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventExhibitorCategoryResource;
use App\Http\Resources\API\Event\EventExhibitorResource;
use App\Models\EventExhibitor;
use App\Models\EventExhibitorCategory;
use Illuminate\Http\Request;

class EventExhibitorController extends Controller
{
    public function index(Request $request)
    {
        try {
            $eventExhibitors = EventExhibitor::where('event_id', $request->attributes->get('event_id'));

            if ($request->filter) {
                $eventExhibitors->where(function ($q) use ($request) {
                    $requestContact = preg_replace("/[^0-9]/", "", $request->filter);
                    $q->where('name', 'like', "%{$request->filter}%")
                        ->orWhere('email', 'like', "%{$request->filter}%")
                        ->orWhereLike('contact', $requestContact);
                });
            }
            if (isset($request->category)) {
                $eventExhibitors->where('event_exhibitor_category_id', $request->category);
            }
            $eventExhibitors = $eventExhibitors->simplePaginate(25);
            $request->merge(['display_scroller_images' => true]);
            return EventExhibitorResource::collection($eventExhibitors);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Exhibitor Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function details(Request $request, EventExhibitor $eventExhibitor)
    {
        return new EventExhibitorResource($eventExhibitor);
    }

    public function categories(Request $request)
    {
        try {
            $eventId = $request->attributes->get('event_id');
            $EventExhibitorCategories = EventExhibitorCategory::where('event_id', $eventId)->get();
            return EventExhibitorCategoryResource::collection($EventExhibitorCategories);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Exhibitor Category Error");
            return $this->sendError($e->getMessage());
        }
    }
}
