<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\EventSession;
use Illuminate\Http\Request;

class EventSessionQuestionController extends Controller
{
    public function store(EventSession $eventSession, Request $request)
    {
        try {
            $data = $request->validate(
                [
                    'question' => ['required', 'string'],
                    'from' => ['required', 'exists:users,id'],
                    'to' => ['nullable', 'exists:users,id'],
                ]
            );

            if ($eventSession->event_id != $request->attributes->get('event_id')) {
                return $this->sendError("Invalid Event");
            }

            if ($eventSession->ask_questions == StatusEnum::DEACTIVE) {
                return $this->sendError("Asking Questions is not allowed in this session");
            }

            $eventSession->questions()
                ->create($data);

            return $this->sendJson(['message' => "Question Submitted Successfully"]);
        } catch (\Exception $e) {
            $this->logError($e, "Question Submission Error");
            return $this->sendError($e->getMessage());
        }
    }
}
