<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventWorkshopResource;
use App\Models\Event;
use App\Models\EventFormWorkshop;
use Illuminate\Http\Request;

class EventWorkshopController extends Controller
{
    public function index(Event $event)
    {
        try {
            $eventFormWorkshops = EventFormWorkshop::where('event_id', $event->id)->where('status', StatusEnum::ACTIVE)->get();
            return EventWorkshopResource::collection($eventFormWorkshops);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Workshop Error");
            return $this->sendError($e->getMessage());
        }
    }
}
