<?php

namespace App\Http\Controllers\API\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventSpeakerTypeResource;
use App\Http\Resources\API\Event\SpeakerResource;
use App\Models\Event;
use App\Models\EventSession;
use App\Models\EventSessionUser;
use App\Models\EventSpeaker;
use App\Models\EventSpeakerType;
use App\Models\User;
use Illuminate\Http\Request;

class SpeakerController extends Controller
{
    public function index(Request $request)
    {
        try {
            // $eventId = $request->attributes->get('event_id');
            // $event = getEventFromId($eventId);
            // $eventSessionsId = $event->eventSessions()->pluck('id')->toArray();

            // $eventSessionUsers = EventSessionUser::whereIn('event_session_id', $eventSessionsId)
            //     ->whereNotNull('event_speaker_id')
            //     ->pluck('event_speaker_id')->toArray();

            // $speakers = User::whereIn('id', $eventSessionUsers);

            // $speakers = $speakers->simplePaginate(25);
            // $request->merge(['event_id' => $eventId]);
            // $request->merge(['display_event_session_details' => true]);
            // return SpeakerResource::collection($speakers);


            /////////////////////////////////////

            $eventId = $request->attributes->get('event_id');
            $speakers = EventSpeaker::where('event_id', $request->attributes->get('event_id'));
            if (isset($request->type)) {
                $speakers->where('event_speaker_type_id', $request->type);
            }
            if ($request->filter) {
                $speakers->where(function ($q) use ($request) {
                    $requestContact = preg_replace("/[^0-9]/", "", $request->filter);
                    $q->where('name', 'like', "%{$request->filter}%")
                        ->orWhere('email', 'like', "%{$request->filter}%")
                        ->orWhereLike('contact', $requestContact);
                });
            }
            $speakers = $speakers->simplePaginate(25);
            $request->merge(['event_id' => $eventId]);
            $request->merge(['display_event_session_details' => true]);
            return SpeakerResource::collection($speakers);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Speakers Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function details(Request $request, EventSpeaker $eventSpeaker)
    {
        try {
            return new SpeakerResource($eventSpeaker);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Speakers Details Error");
            return $this->sendError($e->getMessage());
        }
    }

    public function type(Request $request)
    {
        try {
            $eventId = $request->attributes->get('event_id');
            $speakerTypes = EventSpeakerType::where('event_id', $eventId)->get();
            return EventSpeakerTypeResource::collection($speakerTypes);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Speaker Type Error");
            return $this->sendError($e->getMessage());
        }
    }
}
