<?php

namespace App\Http\Controllers\API\Event;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\Event\EventVenueResource;
use App\Models\EventDay;
use App\Models\EventVenue;
use Illuminate\Http\Request;

class VenueController extends Controller
{
    public function index(Request $request, EventDay $eventDay)
    {
        try {
            $eventVenues = $eventDay->eventVenues();
            if ($request->name) {
                $eventVenues->where(function ($q) use ($request) {
                    $q->orWhere('name', 'like', "%{$request->name}%");
                });
            }
            $request->merge(['display_scroller_images' => true]);
            $eventVenues = $eventVenues->simplePaginate(25);
            return EventVenueResource::collection($eventVenues);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Venues Error");
            return $this->sendError(error: $e->getMessage());
        }
    }

    public function list(Request $request)
    {
        try {
            $eventId = $request->attributes->get('event_id');
            $event = getEventFromId($eventId);
            $eventDaysId = $event->eventDays()->pluck('id')->toArray();
            $eventVenues = EventVenue::whereIn('event_day_id', $eventDaysId);
            $request->merge(['display_scroller_images' => true]);
            $eventVenues = $eventVenues->simplePaginate(25);
            return EventVenueResource::collection($eventVenues);
        } catch (\Exception $e) {
            $this->logError($e, "Get Event Venues List Error");
            return $this->sendError(error: $e->getMessage());
        }
    }
}
