<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\EventResource;
use App\Models\Event;
use Illuminate\Http\Request;

class EventController extends Controller
{
    public function index(Request $request)
    {
        try {
            $events = Event::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->orderByDesc('date');
            $events = $events->filterEvent();
            $events = $events->simplePaginate(20);
            return EventResource::collection($events);
        } catch (\Exception $e) {
            $this->logError($e, "Get Events Error");
            return $this->sendError($e->getMessage());
        }
    }
}
