<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\InternationalAffiliationResource;
use App\Models\InternationalAffiliation;
use Illuminate\Http\Request;

class InternationalAffiliationController extends Controller
{
    public function index(Request $request)
    {
        $internationalAffiliations = InternationalAffiliation::where('association_id', $request->attributes->get('association_id'))->where('status', StatusEnum::ACTIVE)->orderBy('index')->simplePaginate(20);

        return $this->sendJson(InternationalAffiliationResource::collection($internationalAffiliations));
    }
}
