<?php

namespace App\Http\Controllers\API;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\NoticeResource;
use App\Models\Notice;
use Illuminate\Http\Request;

class NoticeController extends Controller
{
    public function index(Request $request)
    {
        try {
            $notices = Notice::where('association_id', $request->attributes->get('association_id'))
                ->where('status', StatusEnum::ACTIVE)
                ->orderBy('index')->get();
            return $this->sendJson(NoticeResource::collection($notices));
        } catch (\Exception $e) {
            $this->logError($e, "Get Notices Error");
            return $this->sendError($e->getMessage());
        }
    }
}
