<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\PastOfficeBearerResource;
use App\Models\PastOfficeBearer;
use Illuminate\Http\Request;

class PastOfficeBearerController extends Controller
{
    public function index(Request $request)
    {
        $pastOfficeBearers = PastOfficeBearer::where('association_id', $request->attributes->get('association_id'))->orderByDesc('year')->simplePaginate(20);

        return $this->sendJson(PastOfficeBearerResource::collection($pastOfficeBearers));
    }
}
