<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\API\UserResource;
use App\Models\MemberDetail;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function getMemberProfile(Request $request)
    {
        $request->validate([
            'registration_number' => ['required', 'string', 'exists:member_details,registration_number'],
        ]);

        try {
            $memberDetail = MemberDetail::where('registration_number', $request->registration_number)->first();
            return new UserResource($memberDetail->user);
        } catch (\Exception $e) {
            $this->logError($e, "fetch profile from registration number error");
            return $this->sendError($e->getMessage());
        }
    }
}
