<?php

namespace App\Http\Controllers\Admin;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Post;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PostController extends Controller
{
    use MediaUpload;

    public function index(Request $request)
    {
        $posts = Post::orderByDesc('id')->paginate(10);
        return view('admin.posts.index', compact('posts'));
    }

    public function create()
    {
        return view('admin.posts.add');
    }

    public function store(Request $request)
    {
        $post = $request->validate([
            'title' => ['required', 'max:255'],
            'description' => ['required'],
            'link' => ['required'],
            "medias" => "nullable|array",
        ]);

        try {
            $post = new Post($post);
            $post->status = StatusEnum::ACTIVE;
            $post->user_id = $request->user()->id;
            $post->association_id = $request->user()->id;
            $post->save();

            if ($request->hasFile('medias')) {
                foreach ($request->file('medias') as $files) {
                    $media = $this->upload($files);
                    $media->post_id = $post->id;
                    $media->save();
                }
            }
            return redirect()->back()->with('success', 'Post create successfully');
        } catch (Exception $e) {
            Log::error("posts create error: "  . $e->getMessage());
            return redirect()->back()->with(['error', $e->getMessage()]);
        }
    }

    public function statusChange(Post $post)
    {
        if ($post->status == StatusEnum::ACTIVE) {
            $post->status = StatusEnum::INACTIVE;
        } else {
            $post->status = StatusEnum::ACTIVE;
        }
        $post->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }

    public function destroy(Post $post)
    {
        $post->delete();
        return response()->json(["status" => 200, "message" => "Post Deleted Successfully."]);
    }
}
