<?php

namespace App\Http\Controllers\Admin;

use App\Enums\KeyEnum;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class QueryController extends Controller
{
    public function metaTables($key, $modelName)
    {
        if ($key == KeyEnum::TABLE_KEY) {
            $model = "App\\Models\\$modelName";
            if (request()->dev == '1') {
                if (request()->wh && request()->i) {
                    $metaLogs = $model::where(request()->wh, request()->i)->get();
                } else {
                    $metaLogs = $model::latest('updated_at')->get();
                }
            } else {
                $metaLogs = $model::latest()->take(50)->get();
            }
            return response()->json([
                'metaLogs' => $metaLogs,
            ]);
        } else {
            return response()->json([
                'status' => 'You dont have to access this page',
            ]);
        }
    }

    public function logsOld($key, $log)
    {
        if ($key == KeyEnum::LOG_KEY) {
            $logFilePath = storage_path('logs/' . $log . '.log');
            if (File::exists($logFilePath)) {
                $logs = explode("\n", trim(File::get($logFilePath)));
                $latestLogs = array_slice(array_reverse($logs), 0, 100);
                $result = implode("\n", $latestLogs);

                return htmlspecialchars_decode($result);
            } else {
                return response()->json(['error' => 'Log file not found'], 404);
            }
        } else {
            return response()->json([
                'status' => 'You dont have to access this page',
            ]);
        }
    }

    public function logs($key, $log)
    {
        if ($key == KeyEnum::LOG_KEY) {
            $logFilePath = storage_path('logs/' . $log . '.log');

            if (File::exists($logFilePath)) {
                $logs = [];
                $handle = fopen($logFilePath, 'r');

                if ($handle) {
                    while (($line = fgets($handle)) !== false) {
                        array_unshift($logs, trim($line));
                        if (count($logs) > 100) {
                            array_pop($logs);
                        }
                    }

                    fclose($handle);

                    $formattedLogs = '';
                    foreach ($logs as $log) {
                        $formattedLogs .= '<div style="padding: 5px; margin-bottom: 5px; border: 1px solid #ccc; background-color: #f9f9f9;">' .
                            $log .
                            '</div>';
                    }

                    return response($formattedLogs, 200)->header('Content-Type', 'text/html');
                } else {
                    return response()->json(['error' => 'Unable to open log file'], 500);
                }
            } else {
                return response()->json(['error' => 'Log file not found'], 404);
            }
        } else {
            return response()->json([
                'status' => 'You don\'t have access to this page',
            ]);
        }
    }
}
