<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {

        $settings  = Setting::first();
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->except(['_token', '_method']);
        $setting = Setting::first();

        // Use updateOrCreate directly without an if-else
        Setting::updateOrCreate(['id' => $setting->id ?? null], $data);

        return redirect()->route('settings.index')->with('success', 'Settings Saved');
    }
}
