<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;

class UserController extends Controller
{
    public function index(Request $request)
    {
        $columns = array_diff(
            Schema::getColumnListing('users'),
            ['password', 'remember_token', 'extra', 'Wati_id', 'status', 'id', 'unique_id']
        );

        $users = User::latest('id')
            ->when($request->name, function ($query, $name) {
                $query->where('name', 'like', "%{$name}%");
            })
            ->when($request->email, function ($query, $email) {
                $query->where('email', 'like', "%{$email}%");
            })
            ->when($request->contact, function ($query, $contact) {
                $query->where('contact', 'like', "%{$contact}%");
            });

        // ->when($request->unique_id, function ($query, $unique_id) {
        //     $query->where('unique_id', 'like', "%{$unique_id}%");
        // });

        $users = $users->paginate();

        return view('admin.user.index', compact('users', 'request', 'columns'));
    }
}
