<?php

namespace App\Http\Controllers\Association;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\MemberRole;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MemberRoleController extends Controller
{

    public function index(Request $request)
    {
        $memberRoles = MemberRole::where('association_id', Auth::user()->id)->orderBy('id', 'asc');
        $memberRoles = $memberRoles->paginate(25);
        return view('association.member-roles.index', compact('memberRoles', 'request'));
    }

    public function create()
    {
        return view('association.member-roles.add');
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required'],
        ]);

        if (MemberRole::where('name', $request->name)->where('association_id', Auth::user()->id)->exists()) {
            return redirect()->back()->with('error', "The Name has already been taken.")->withInput();
        }

        $data = $request->except(['_token', '_method']);
        $data["association_id"] = Auth::user()->id;

        MemberRole::create($data);

        return redirect()->route('member.roles.index')->with('success', 'Role Created');
    }

    public function edit(MemberRole $memberRole)
    {
        return view('association.member-roles.edit', compact('memberRole'));
    }

    public function update(MemberRole $memberRole, Request $request)
    {
        $request->validate([
            'name' => ['required']
        ]);

        if (MemberRole::where('name', $request->name)->where('association_id', Auth::user()->id)
            ->whereNot('id', $memberRole->id)->exists()
        ) {
            return redirect()->back()->with('error', "The Name has already been taken.")->withInput();
        }
        
        $data = $request->except(['_token', '_method']);

        $memberRole->update($data);
        return redirect()->route('member.roles.index')->with('success', 'Role Updated');
    }


    public function statusChange(MemberRole $memberRole)
    {
        if ($memberRole->status == StatusEnum::ACTIVE) {
            $memberRole->status = StatusEnum::INACTIVE;
        } else {
            $memberRole->status = StatusEnum::ACTIVE;
        }
        $memberRole->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }


    public function destroy(MemberRole $memberRole)
    {
        $memberRole->delete();
        return response()->json(["status" => 200, "message" => "Role Deleted"]);
    }
}
