<?php

namespace App\Http\Controllers\Association;

use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\AssociationDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SettingController extends Controller
{
    use MediaUpload;

    public function index()
    {
        $associationSetting = AssociationDetail::where('association_id', Auth::user()->id)->first();
        return view('association.settings.index', compact('associationSetting'));
    }

    public function update(Request $request)
    {
        $data = $request->except(['_token', '_method']);
        $setting = AssociationDetail::where('association_id', Auth::user()->id)->first();
        if ($request->logo) {
            $data['logo'] = $this->upload($request->logo)->id;
        }
        if ($request->badge) {
            $data['badge_media_id'] = $this->upload($request->badge)->id;
        }
        if ($request->card) {
            $data['card_media_id'] = $this->upload($request->card)->id;
        }
        $data['association_id'] = Auth::user()->id;
        AssociationDetail::updateOrCreate(['id' => $setting->id ?? null], $data);

        return redirect()->route('association.settings.index')->with('success', 'Settings Saved');
    }
}
