<?php

namespace App\Http\Controllers\Auth;

use App\Enums\AdminLevel;
use App\Enums\RoleEnum;
use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    protected function authenticated($user)
    {
        $user = Auth::user();
        if ($user->role = RoleEnum::ASSOCIATION && $user->status != StatusEnum::ACTIVE) {
            Auth::logout();
            return redirect('/login')->withErrors([
                'email' => 'Your account is not active, please contact administrator.'
            ]);
        }
        return redirect('/home');
    }

    public function showLoginForm()
    {
        if (Auth::guard('admin')->check()) {

            $admin = auth()->guard('admin')->user();
            if ($admin->role == AdminLevel::EVENT_COORDINATOR) {
                return redirect()->route('event.coordinator.home', Session::get('event_code'));
            }

            return redirect()->route('event.home');
        }
        return view('auth.login');
    }
}
