<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\EventBankDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventBankDetailController extends Controller
{
    public function index()
    {
        $bankDetail = EventBankDetail::where('event_id', Session::get('event_id'))->first();
        return view('event.bank-detail.index', compact('bankDetail'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'bank_details' => ['required'],
        ]);
        $bankDetail = EventBankDetail::where('event_id', Session::get('event_id'))->first();
        $data['event_id'] = Session::get('event_id');
        EventBankDetail::updateOrCreate(['id' => $bankDetail->id ?? null], $data);

        return redirect()->route('event.bank.details.index')->with('success', 'Bank Details Saved');
    }
}
