<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Event;
use App\Models\ScrollerImage;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class EventBannerController extends Controller
{
    use MediaUpload;

    public function imagesIndex()
    {
        $event = getEventFromId(Session::get('event_id'));

        $title = 'Event Banner';
        $addRoute = route('event.banners.add');

        $scrollImages = $event->bannerImages()->paginate(25);
        return view('event.scroll-images.index', compact('scrollImages', 'event', 'title', 'addRoute'));
    }

    public function imageAdd(Event $event)
    {
        $event = getEventFromId(Session::get('event_id'));

        $title = $event->title;
        $storeRoute = route('event.banners.store');

        return view('event.scroll-images.add', compact('title', 'storeRoute'));
    }

    public function imagestore(Request $request)
    {
        $request->validate([
            'image' => ['required', 'image', 'max:2048'],
        ]);
        $event = getEventFromId(Session::get('event_id'));

        $scrollerImage = new ScrollerImage([
            'index' => $request->index ?? 0,
            'media_id' => $this->upload($request->image)->id,
            'type' => ScrollerImage::TYPE_BANNER,
        ]);
        $event->bannerImages()->save($scrollerImage);
        return redirect()->route('event.banners.index')->with('success', 'Image Saved');
    }
}
