<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventButton;
use Illuminate\Http\Request;

class EventButtonController extends Controller
{
    public function create()
    {
        return view('event.about-us.button.add');
    }

    public function store(Request $request, Event $event)
    {
        $request->validate([
            'name' => ['required'],
            'link' => ['required'],
            'index' => ['nullable'],
        ]);
        $data = $request->except(['_token', '_method']);
        $data['event_id'] = $event->id;
        $data['index'] = $request->index ?? EventButton::max('index') + 1;
        EventButton::create($data);
        return redirect()->route('event.aboutus.index')->with('success', 'Button Saved');
    }

    public function edit(EventButton $button)
    {
        return view('event.about-us.button.edit', compact('button'));
    }

    public function update(Request $request, EventButton $button)
    {
        $request->validate([
            'name' => ['required'],
            'link' => ['required'],
            'index' => ['nullable'],
        ]);
        $data = $request->except(['_token', '_method']);
        $data['index'] = $request->index ?? EventButton::max('index') + 1;
        $button->update($data);
        return redirect()->route('event.aboutus.index')->with('success', 'Button Updated');
    }

    public function destroy(EventButton $button)
    {
        $button->delete();
        return response()->json(["status" => 200, "message" => "Button Deleted"]);
    }
}
