<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventContactUs;
use App\Models\EventContactUsType;
use App\Rules\DisposableEmailRule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;

class EventContactUsController extends Controller
{
    public function index(Request $request)
    {
        $eventContactUs = EventContactUs::where('event_id', Session::get('event_id'));

        if ($request->filter) {
            $eventContactUs->where(function ($q) use ($request) {
                $requestContact = preg_replace("/[^0-9]/", "", $request->filter);
                $q->where('name', 'like', "%{$request->filter}%")
                    ->orWhereLike('contact', $requestContact);
            });
        }
        $eventContactUs = $eventContactUs->paginate(25);
        return view('event.contact-us.index', compact('eventContactUs', 'request'));
    }

    public function create(Request $request)
    {
        $eventContactUsType = EventContactUsType::where('event_id', Session::get('event_id'))->get();
        return view('event.contact-us.create', compact('eventContactUsType'));
    }

    public function store(Request $request, Event $event)
    {
        $request->validate([
            'event_contact_us_type_id' => ['required', 'exists:event_contact_us_types,id'],
            'name' => ['required', 'string'],
            'email' => ['nullable'],
            'country_code' => ['required'],
            'contact' => ['required', 'digits:10'],
            'designation' => ['nullable'],
        ]);
        $data = $request->except(['_token', '_method']);
        $data['country_code'] = "+" . str_replace('+', '', $data['country_code']);
        $event->eventContactUs()->create($data);
        return redirect()->route('event.contact.us.index')->with('success', 'Contact Us Created');
    }

    public function edit(EventContactUs $eventContactUs)
    {
        $eventContactUsType = EventContactUsType::where('event_id', Session::get('event_id'))->get();
        return view('event.contact-us.edit', compact('eventContactUs', 'eventContactUsType'));
    }

    public function update(EventContactUs $eventContactUs, Request $request)
    {
        $request->validate([
            'event_contact_us_type_id' => ['required', 'exists:event_contact_us_types,id'],
            'name' => ['required', 'string'],
            'email' => ['nullable'],
            'country_code' => ['required'],
            'contact' => ['required', 'digits:10'],
            'designation' => ['nullable'],
        ]);

        $data = $request->except(['_token', '_method']);
        $data['country_code'] = "+" . str_replace('+', '', $data['country_code']);
        $eventContactUs->update($data);
        return redirect()->route('event.contact.us.index')->with('success', 'Contact Us Updated');
    }

    public function destroy(EventContactUs $eventContactUs)
    {
        $eventContactUs->delete();
        return response()->json(["status" => 200, "message" => "Contact Us Deleted"]);
    }
}
