<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventContactUsType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventContactUsTypeController extends Controller
{
    public function index(Request $request)
    {
        $eventContactUsTypes = EventContactUsType::where('event_id', Session::get('event_id'));
        $eventContactUsTypes = $eventContactUsTypes->paginate(25);
        return view('event.contact-us.type', compact('request', 'eventContactUsTypes'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventContactUsType::max('index') + 1;
        $event->eventContactUsTypes()->create($data);
        return redirect()->route('event.contact.us.type.index')->with('success', 'Contact Us Type Created');
    }

    public function update(Request $request, EventContactUsType $eventContactUsType)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventContactUsType::max('index') + 1;
        $eventContactUsType->update($data);
        return redirect()->route('event.contact.us.type.index')->with('success', 'Contact Us Type Updated');
    }

    public function destroy(EventContactUsType $eventContactUsType)
    {
        $eventContactUsType->delete();
        return response()->json(["status" => 200, "message" => "Contact Us Type Deleted"]);
    }
}
