<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventDesignation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;

class EventDesignationController extends Controller
{
    public function index(Request $request)
    {
        $eventDesignations = EventDesignation::where('event_id', Session::get('event_id'));
        $eventDesignations = $eventDesignations->paginate(25);
        return view('event.designation.index', compact('request', 'eventDesignations'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'designation' => [
                'required',
                'string',
                Rule::unique('event_designations')->where(function ($query) use ($event) {
                    return $query->where('event_id', $event->id);
                })
            ]
        ]);
        
        $event->eventDesignations()->create($data);
        return redirect()->route('event.designations.index')->with('success', 'Designation Created');
    }

    public function update(Request $request, EventDesignation $eventDesignation)
    {
        $data = $request->validate([
            'designation' => ['required', Rule::unique('event_designations', 'designation')->ignore($eventDesignation->id)]
        ]);

        $eventDesignation->update($data);
        return redirect()->route('event.designations.index')->with('success', 'Designation Updated');
    }

    public function destroy(EventDesignation $eventDesignation)
    {
        $eventDesignation->delete();
        return response()->json(["status" => 200, "message" => "Designation Deleted"]);
    }
}
