<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventDocumentList;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventDocumentListController extends Controller
{
    public function index(Request $request)
    {
        $eventDocumentLists = EventDocumentList::where('event_id', Session::get('event_id'));
        $eventDocumentLists = $eventDocumentLists->paginate(25);
        return view('event.document-list.index', compact('request', 'eventDocumentLists'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventDocumentList::max('index') + 1;
        $event->eventDocumentLinks()->create($data);
        return redirect()->route('event.document.lists.index')->with('success', 'Document Created');
    }

    public function update(Request $request, EventDocumentList $eventDocumentList)
    {
        $data = $request->validate([
            'title' => ['required', 'string'],
            'link' => ['required', 'url'],
            'index' => ['nullable', 'integer'],
        ]);
        $data["index"] = $request->index ?? EventDocumentList::max('index') + 1;
        $eventDocumentList->update($data);
        return redirect()->route('event.document.lists.index')->with('success', 'Document Updated');
    }

    public function destroy(EventDocumentList $eventDocumentList)
    {
        $eventDocumentList->delete();
        return response()->json(["status" => 200, "message" => "Document Deleted"]);
    }
}
