<?php

namespace App\Http\Controllers\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventEPosterCategory;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class EventEposterCategoryController extends Controller
{
    public function index(Request $request)
    {
        $eventEPosterCategories = EventEPosterCategory::where('event_id', Session::get('event_id'));
        $eventEPosterCategories = $eventEPosterCategories->paginate(25);
        return view('event.e-poster-category.index', compact('request', 'eventEPosterCategories'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $event->eventEPosterCategories()->create([
            "name" => $data['name'],
        ]);
        return redirect()->route('event.eposter.category.index')->with('success', 'E-Poster Category Created');
    }

    public function update(Request $request, EventEPosterCategory $eventEPosterCategory)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $eventEPosterCategory->update([
            "name" => $data['name'],
        ]);
        return redirect()->route('event.eposter.category.index')->with('success', 'E-Poster Category Updated');
    }

    public function statusChange(EventEPosterCategory $eventEPosterCategory)
    {
        if ($eventEPosterCategory->status == StatusEnum::ACTIVE) {
            $eventEPosterCategory->status = StatusEnum::INACTIVE;
        } else {
            $eventEPosterCategory->status = StatusEnum::ACTIVE;
        }
        $eventEPosterCategory->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }

    public function destroy(EventEPosterCategory $eventEPosterCategory)
    {
        $eventEPosterCategory->delete();
        return response()->json(["status" => 200, "message" => "E-Poster Category Deleted"]);
    }
}
