<?php

namespace App\Http\Controllers\Event\EventForm;

use App\Http\Controllers\Controller;
use App\Models\EventUpiDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class UpiDetailController extends Controller
{
    public function index()
    {
        $upiDetail = EventUpiDetail::where('event_id', Session::get('event_id'))->first();
        return view('event.event-form.upi-details.index', compact('upiDetail'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'upi_id' => ['required'],
            'payee_name' => ['required'],
        ]);
        $bankDetail = EventUpiDetail::where('event_id', Session::get('event_id'))->first();
        $data['event_id'] = Session::get('event_id');
        EventUpiDetail::updateOrCreate(['id' => $bankDetail->id ?? null], $data);

        return redirect()->route('event.forms.upi.details.index')->with('success', 'UPI Details Saved');
    }
}
