<?php

namespace App\Http\Controllers\Event\EventForm;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventFormWorkshop;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class WorkshopController extends Controller
{
    public function index(Request $request)
    {
        $eventFormWorkshops = EventFormWorkshop::where('event_id', Session::get('event_id'));
        $eventFormWorkshops = $eventFormWorkshops->paginate(25);
        return view('event.event-form.workshop.index', compact('request', 'eventFormWorkshops'));
    }

    public function create()
    {
        return view('event.event-form.workshop.create');
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => 'required|string',
            'start_date' => 'required',
            'end_date' => 'required',
            'venue' => 'required',
            'registration_fee' => 'required',
            'registration_limit' => 'required',
        ]);
        $data['start_date'] = date('Y-m-d', strtotime($request->start_date));
        $data['end_date'] = date('Y-m-d', strtotime($request->end_date));
        $event->eventFormWorkshops()->create($data);

        return redirect()->route('event.forms.workshops.index')->with('success', 'Workshop Created');
    }

    public function edit(EventFormWorkshop $eventFormWorkshop)
    {
        return view('event.event-form.workshop.edit', compact('eventFormWorkshop'));
    }
    public function update(EventFormWorkshop $eventFormWorkshop, Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string',
            'start_date' => 'required',
            'end_date' => 'required',
            'venue' => 'required',
            'registration_fee' => 'required',
            'registration_limit' => 'required',
        ]);
        $data['start_date'] = date('Y-m-d', strtotime($request->start_date));
        $data['end_date'] = date('Y-m-d', strtotime($request->end_date));
        $eventFormWorkshop->update($data);

        return redirect()->route('event.forms.workshops.index')->with('success', 'Workshop Updated');
    }
    public function statusChange(EventFormWorkshop $eventFormWorkshop)
    {
        if ($eventFormWorkshop->status == StatusEnum::ACTIVE) {
            $eventFormWorkshop->status = StatusEnum::INACTIVE;
        } else {
            $eventFormWorkshop->status = StatusEnum::ACTIVE;
        }
        $eventFormWorkshop->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }
    public function destroy(EventFormWorkshop $eventFormWorkshop)
    {
        $eventFormWorkshop->delete();
        return response()->json(["status" => 200, "message" => "Workshop Deleted"]);
    }
}
