<?php

namespace App\Http\Controllers\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventImportantDate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventImportantDateController extends Controller
{
    public function index(Request $request)
    {
        $eventImportantDates = EventImportantDate::where('event_id', Session::get('event_id'));
        $eventImportantDates = $eventImportantDates->paginate(25);
        return view('event.important-date.index', compact('request', 'eventImportantDates'));
    }

    public function create()
    {
        return view('event.important-date.add');
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'date' => ['required'],
            'description' => ['required'],
            'status' => ['required'],
        ]);
        $data['date'] = date('Y-m-d', strtotime($data['date']));
        $event->eventImportantDates()->create($data);
        return redirect()->route('event.important.dates.index')->with('success', 'Important Date Created');
    }

    public function edit(EventImportantDate $eventImportantDate)
    {
        return view('event.important-date.edit', compact('eventImportantDate'));
    }
    public function update(EventImportantDate $eventImportantDate, Request $request)
    {
        $data = $request->validate([
            'date' => ['required'],
            'description' => ['required'],
            'status' => ['required'],
        ]);
        $data['date'] = date('Y-m-d', strtotime($data['date']));
        $eventImportantDate->update($data);
        return redirect()->route('event.important.dates.index')->with('success', 'Important Date Updated');
    }
    public function statusChange(EventImportantDate $eventImportantDate)
    {
        if ($eventImportantDate->status == StatusEnum::ACTIVE) {
            $eventImportantDate->status = StatusEnum::INACTIVE;
        } else {
            $eventImportantDate->status = StatusEnum::ACTIVE;
        }
        $eventImportantDate->save();
        return response()->json(["status" => 200, "message" => "Status Changed"]);
    }
    public function destroy(EventImportantDate $eventImportantDate)
    {
        $eventImportantDate->delete();
        return response()->json(["status" => 200, "message" => "Important Date Deleted"]);
    }
}
