<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\Event;
use App\Models\EventLocation;
use App\Models\Media;
use Illuminate\Http\Request;

class EventLocationController extends Controller
{
    use MediaUpload;
    public function create()
    {
        return view('event.about-city.location.add');
    }

    public function store(Request $request, Event $event)
    {
        $request->validate([
            'name' => ['required'],
            'location_link' => ['nullable', 'url'],
        ]);
        $data = $request->except(['_token', '_method']);
        $data['event_id'] = $event->id;
        $data["index"] = $request->index ?? EventLocation::max('index') + 1;
        
        $mediaIds = [];
        if (isset($request->images)) {
            foreach ($request->images as $image) {
                $mediaId = $this->upload($image)->id;
                $mediaIds[] = $mediaId;
            }
        }
        $data['media_ids'] = implode(',', $mediaIds);
        if ($request->location_link) {
            $data['extra'] = [
                'location_link' => $request->get('location_link', ''),
            ];
        }
        EventLocation::create($data);
        return redirect()->route('event.aboutCity.index')->with('success', 'Location Saved');
    }

    public function edit(EventLocation $location)
    {
        if ($location && !empty($location->media_ids)) {
            $mediaIds = is_array($location->media_ids) ? $location->media_ids : explode(',', $location->media_ids);
            $images = Media::whereIn('id', $mediaIds)->get();
        } else {
            $images = collect();
        }
        return view('event.about-city.location.edit', compact('location', 'images'));
    }

    public function update(Request $request, EventLocation $location)
    {
        $request->validate([
            'name' => ['required'],
        ]);
        $data = $request->except(['_token', '_method']);

        $mediaIds = [];
        if (!empty($location->media_ids)) {
            $existingMediaIds = explode(',', $location->media_ids);
            $validMediaIds = Media::whereIn('id', $existingMediaIds)->pluck('id')->toArray();
            $mediaIds = array_merge($mediaIds, $validMediaIds);
        }
        if (isset($request->images)) {
            foreach ($request->images as $image) {
                $mediaId = $this->upload($image)->id;
                $mediaIds[] = $mediaId;
            }
            $mediaIds = array_unique($mediaIds);
        }
        $data['media_ids'] = implode(',', $mediaIds);
        $data["index"] = $request->index ?? EventLocation::max('index') + 1;

        if ($request->location_link) {
            $data['extra'] = [
                'location_link' => $request->get('location_link', ''),
            ];
        }
        $location->update($data);
        return redirect()->route('event.aboutCity.index')->with('success', 'Location Updated');
    }

    public function destroy(EventLocation $location)
    {
        if (!empty($location->media_ids)) {
            $existingMediaIds = explode(',', $location->media_ids);
            $Medias = Media::whereIn('id', $existingMediaIds)->get();
            foreach ($Medias as $media) {
                $this->remove($media->path);
                $media->delete();
            }
        }
        $location->delete();
        return response()->json(["status" => 200, "message" => "Location Deleted"]);
    }

    public function mediaDelete(Media $media)
    {
        $this->remove($media->path);
        $media->delete();
        return response()->json(["status" => 200, "message" => "Image Deleted"]);
    }
}
