<?php

namespace App\Http\Controllers\Event;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventSpeakerType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class EventSpeakerTypeController extends Controller
{
    public function index(Request $request)
    {
        $eventSpeakerTypes = EventSpeakerType::where('event_id', Session::get('event_id'));
        $eventSpeakerTypes = $eventSpeakerTypes->paginate(25);
        return view('event.speaker.type', compact('request', 'eventSpeakerTypes'));
    }

    public function store(Request $request, Event $event)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $event->eventSpeakerTypes()->create([
            "name" => $data['name'],
        ]);
        return redirect()->route('event.speakers.type.index')->with('success', 'Speaker Type Created');
    }

    public function update(Request $request, EventSpeakerType $eventSpeakerType)
    {
        $data = $request->validate([
            'name' => ['required', 'string'],
        ]);
        $eventSpeakerType->update([
            "name" => $data['name'],
        ]);
        return redirect()->route('event.speakers.type.index')->with('success', 'Speaker Type Updated');
    }

    public function destroy(EventSpeakerType $eventSpeakerType)
    {
        $eventSpeakerType->delete();
        return response()->json(["status" => 200, "message" => "Speaker Type Deleted"]);
    }
}
