<?php

namespace App\Http\Controllers\Event;

use App\Enums\StatusEnum;
use App\Http\Controllers\Controller;
use App\Http\Traits\MediaUpload;
use App\Models\ScrollerImage;
use Illuminate\Http\Request;

class ScrollableImagesController extends Controller
{
    use MediaUpload;

    public function imagestatusChange(ScrollerImage $image)
    {
        $newStatus = ($image->status == StatusEnum::ACTIVE) ? StatusEnum::INACTIVE : StatusEnum::ACTIVE;
        $image->status = $newStatus;
        $image->save();
        return response()->json(["status" => 200, "message" => "Image Status Changed"]);
    }

    public function imageUpdateIndex(Request $request, ScrollerImage $image)
    {
        $request->validate([
            'index' => 'required',
        ]);
        try {
            $image->index = $request->index;
            $image->update();
            if ($request->expectsJson()) {
                return response()->json([
                    'success' => 'success',
                    'message' => 'Index change successfully',
                ]);
            }
            // return redirect()->route('event.venues.images.index', $image->imageable->id ?? '');
        } catch (\Exception $e) {
            return redirect()->back()->with(['error', $e->getMessage()]);
        }
    }

    public function imagedestroy(ScrollerImage $image)
    {
        $this->remove($image->image->path);
        $image->delete();
        return response()->json(["status" => 200, "message" => "Image Deleted"]);
    }
}
