<?php

namespace App\Http\Controllers;

use App\Enums\RoleEnum;
use App\Enums\StatusEnum;
use App\Imports\DataImport;
use App\Jobs\ImportDataJob;
use App\Jobs\SendEventNotificationJob;
use App\Jobs\SendMailJob;
use App\Models\EventFormWorkshop;
use App\Models\EventSession;
use App\Models\EventSpeaker;
use App\Models\InternationalAffiliation;
use App\Models\PastOfficeBearer;
use App\Models\Post;
use App\Models\PostBookmark;
use App\Models\PostComment;
use App\Models\PostLike;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;
use Maatwebsite\Excel\Facades\Excel;

class TestController extends Controller
{
    public function importData()
    {
        $path = storage_path('excel/ESI_Data.xlsx');

        if (file_exists($path)) {
            ImportDataJob::dispatchSync($path);
            return response()->json('Import started.');
        }
        return response()->json('File Not Found.');
    }

    public function index()
    {
        // dd(getMailjetTemplates());
        // $apiKey = config('mail.mailers.mailjet.key');
        // $apiSecret = config('mail.mailers.mailjet.secret');

        // $apiKey = 'd5a256e87b6f61262508824372d5aa14';
        // $apiSecret = '27d40a69a7bd4c2b69f852fe54994481';


        // $response = Http::withBasicAuth($apiKey, $apiSecret)
        //     ->get('https://api.mailjet.com/v3/REST/template?limit=1000');
        // dd($response->json());


        dispatch_sync(new SendMailJob(
            [
                'Email' => 'itshq2020@gmail.com',
            ],
            [
                [
                    'Email' => "testerstesting.st@gmail.com",
                ]
            ],
            "New Test!",
            6337066,
            [
                'name' => "Asim",
                'contact' => 9849145564,
                'email' => "EEEMMMAAAIIILL",
                'firstname' => "Asim",
            ],
            [
                [
                    'ContentType' => "text/plain",
                    'Filename' => "test.txt",
                    'Base64Content' => "VGhpcyBpcyB5b3VyIGF0dGFjaGVkIGZpbGUhISEK"
                ],
                [
                    'ContentType' => "application/pdf",
                    'Filename' => "sample.pdf",
                    'Base64Content' => base64_encode(file_get_contents(storage_path('sample.pdf'))),
                ],
                [
                    'ContentType' => "application/vnd.ms-excel",
                    'Filename' => "sample.xlsx",
                    'Base64Content' => base64_encode(file_get_contents(storage_path('file_example_XLS_10.xls'))),
                ],
                [
                    'ContentType' => "application/doc",
                    'Filename' => "sample.doc",
                    'Base64Content' => base64_encode(file_get_contents(storage_path('file-sample_100kB.doc'))),
                ],
                [
                    'ContentType' => "application/docx",
                    'Filename' => "sample.docx",
                    'Base64Content' => base64_encode(file_get_contents(storage_path('file-sample_100kB.docx'))),
                ],
            ],
        ));
        return response()->json('Mail Send Successfully!!');
    }

    public function test()
    {
        $data = [
            [
                "association_id" => '18',
                "year" => 2024,
                "secretary_id" => "627",
                "president_id" => "519",
                "treasurer_id" => "1660",
                "vice_president_id" => '1670',
                'created_at' => now()

            ],
            [
                "association_id" => '18',
                "year" => 2023,
                "secretary_id" => "627",
                "president_id" => "519",
                "treasurer_id" => "1670",
                "vice_president_id" => '1669',
                'created_at' => now()
            ],
            [
                "association_id" => '18',
                "year" => 2022,
                "secretary_id" => "627",
                "president_id" => "519",
                "treasurer_id" => "1660",
                "vice_president_id" => '1669',
                'created_at' => now()
            ],
            [
                "association_id" => '18',
                "year" => 2021,
                "secretary_id" => "627",
                "president_id" => "519",
                "treasurer_id" => "1670",
                "vice_president_id" => '1670',
                'created_at' => now()
            ],
        ];
        PastOfficeBearer::insert($data);
        return "Past bearer Added successfully";
    }

    public function internationalAffiliations()
    {
        $data = [
            [
                "association_id" => '18',
                "name" => "International Society of Endocrinology",
                "media_id" => '82',
                "link" => "https://endocrinesocietyindia.org/international_affiliations.php",
                "status" => StatusEnum::ACTIVE,
                "index" => '3',
                'created_at' => now()

            ],
            [
                "association_id" => '18',
                "name" => "South Asian Federation of Endocrine Societies",
                "media_id" => '81',
                "link" => "https://endocrinesocietyindia.org/international_affiliations.php",
                "status" => StatusEnum::ACTIVE,
                "index" => '1',
                'created_at' => now()
            ],
            [
                "association_id" => '18',
                "name" => "Eastern Asian Federation of Endocrine Department",
                "media_id" => '81',
                "link" => "https://endocrinesocietyindia.org/messages.php",
                "status" => StatusEnum::ACTIVE,
                "index" => '2',
                'created_at' => now()
            ],
        ];
        InternationalAffiliation::insert($data);
        return "International Affiliations Added successfully";
    }
}
