<?php

namespace App\Http\Middleware;

use App\Models\EventManager;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class EventManagerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::guard('admin')->check()) {
            $eventManagerEvent = EventManager::where('admin_id', Auth::guard('admin')->user()->id)->first();

            // If the event manager doesn't exist or has no associated event, logout
            if (!$eventManagerEvent || !$eventManagerEvent->event) {
                Auth::guard('admin')->logout();
                $request->session()->invalidate();
                return redirect()->route('event.login');
            }
        }

        return $next($request);
    }
}
