<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AssociationDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'association_id' => $this->association_id,
            'logo' => new MediaResource($this->media),
            'badge' => new MediaResource($this->badge),
            'card' => new MediaResource($this->card),
            'about' => $this->about,
            'vision' => $this->vision,
            'mission' => $this->mission,
        ];
    }
}
