<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventActivityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $medias = collect();

        if (!empty($this->media_ids)) {
            $mediaIds = json_decode($this->media_ids);
            $medias = Media::whereIn('id', $mediaIds)->get();
        }

        return [
            'id' => $this->id,
            'event_id' => $this->event_id,
            'name' => $this->name,
            'title' => $this->title,
            'description' => $this->description,
            'link' => $this->link,
            'index' => $this->index,
            'media' => MediaResource::collection($medias),
        ];
    }
}
