<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventAppHomeButtonResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'name' => $this->name,
            'key' => $this->key,
            'link' => $this->link,
            'text_color' => $this->text_color,
            'bg_color' => $this->bg_color,
            'index' => $this->index,
            'status' => $this->status,
            'media' => new MediaResource($this->image),
            'type' => $this->type,
        ];

        return $data;
    }
}
