<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use App\Http\Resources\API\MemberResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventCommitteeMemberResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $member = $this->member;
        return [
            'id' => $member->id ?? null,
            'index' => $this->index ?? null,
            'event_id' => $this->event_id ?? null,
            'event_role' => $this->role->name ?? null,
            'member' => new MemberResource($member)
        ];
    }
}
