<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventDashboardSponsorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'name' => $this->name,
            'link' => $this->link,
            'media' => new MediaResource($this->image),
            'index' => $this->index,
        ];
        return $data;
    }
}
